#include <include.h>


//*****************************************************************************
// Function    :
// Description : .
//*****************************************************************************
void Sleep_CMD(unsigned char sleepmode)
{
   int index;
   if (sleepmode>3) SCR = SCR_SLEEPDEEP; // deepsleep mode
   PWRKEY = PWRKEY_VALUE_KEY1;
   PWRKEY = PWRKEY_VALUE_KEY2;
   PWRMOD = sleepmode;
   for (index=0;index<2;index++); 
   WFI();  // Go to sleep!
   for (index=0;index<2;index++);  
}

//*****************************************************************************
// Function    :
// Description : .
//*****************************************************************************/
int main (void)
{   
   boolean              bOk            = TRUE; 

      // Initialise
   T3CON &= ~T3CON_ENABLE;  // Turn off watchdog

   GP2CON = GP2CON_CON0_SPI0MISO | GP2CON_CON1_SPI0SCLK | GP2CON_CON2_SPI0MOSI |
            GP2CON_CON3_GPIO     | GP2CON_CON4_IRQ8     | GP2CON_CON5_GPIO    |
            GP2CON_CON6_GPIO     | GP2CON_CON7_GPIO;

   GP2OEN  = GP2OEN_OEN0_IN    |  GP2OEN_OEN1_IN    |  GP2OEN_OEN2_IN    |
             GP2OEN_OEN3_OUT   |  GP2OEN_OEN4_IN    |  GP2OEN_OEN5_IN    |
             GP2OEN_OEN6_IN    |  GP2OEN_OEN7_IN;
   
   // SPI peripheral configuration (this is prone to rounding errors!!)
   SPI0DIV                   = ((UCLK/SPI_CLK_FREQ)/2)-0x1;

   // SPI Configuration - Master, interrupt on transmit.
   SPI0CON                   = SPI0CON_MASEN   |    // Master mode
                               SPI0CON_TIM     |    // Interrupt on transmit
                               SPI0CON_TFLUSH  |    // FLush FIFO
                               SPI0CON_RFLUSH  |    // FLush FIFO
                               SPI0CON_ENABLE;

   SPI0CON                   = SPI0CON_MASEN  |    // Master mode
                               SPI0CON_TIM    |    // Interrupt on transmit
                               SPI0CON_ENABLE;
    
  while (GP0IN & GP0IN_IN7)   {}  // wait for user to pull P0.7 low
  bOk   = bOk && ADF_FirstConnect();                           
  bOk   = bOk && ADF_IssueCommandNW(CMD_HW_RESET); 
     
  SPI0CON = 0;
  COMCON = 1;
  
  Sleep_CMD(5) ;  // should see 1.8 uA
    
  while (1){}  
}






